package nestedstate;

import java.util.*;
import nestedstate.tools.SkipAction;

/**
* This class models a State. A state has a name and entry /exit actions.
* Further state also contains a dispatch mechanism for incoming events.
*/
public class LeafState extends State
{
        Hashtable transitions = new Hashtable();

        public static FSMAction skip = new FSMAction() {
                public void execute(FSMContext fsmc, Object data)
                {
                }
        };
        
        FSMAction onStateEntry = skip;
        FSMAction onStateExit = skip;
        
        public LeafState(String s)
        { 
                super(s);
        }

        public void setStateEntryAction(FSMAction action) 
        { 
                onStateEntry = action; 
        }

        public FSMAction getStateEntryAction() 
        { 
                return onStateEntry; 
        }

        public void setStateExitAction(FSMAction action) 
        {
                onStateExit = action; 
        }
        
        public FSMAction getStateExitAction() 
        {
                return onStateExit;
        }
        
        /**
        * Adds a transition with this state as source and parameter to as a
        * target. Since to is a node state this method calls addTransition 
        * recursively to set the targetstate to a LeafState.
        * @param trigger The event that triggers the transition
        * @param to The target state.
        * @param action The associated action
        */
        public void addTransition(NodeState to,
                                  FSMEvent trigger,                                    
                                  FSMAction action)
        {
                State s = to.getDefaultState();
                if(s instanceof LeafState)
                        addTransition((LeafState)s, trigger, action);
                else if(s instanceof NodeState)
                        addTransition((NodeState)s, trigger, action);
        }
        
        public void addTransition(LeafState to, 
                                  FSMEvent trigger,                                   
                                  FSMAction action)
        {
                Transition t = new Transition(this, to, action);
                transitions.put(trigger, t);                
        }
      

        /**
        * Dispatch an event.
        * @param trigger The event that needs to be dispatched. The correct 
        * transition is located and than executed.
        * @param data Some additional data that may be needed by the action
        * @param fsmc The context in which the action is executed. This may be 
        * useful for retrieving global variables.
        */
        public void dispatch(FSMEvent trigger, 
                             Object data, 
                             FSMContext fsmc)
        {
                Transition t = (Transition)transitions.get(trigger);
                t.execute(fsmc, data);                
        }
        
        /**
        * Method to find out which events can be dispatched by this state.
        * @return A vector with the events 
        */
        public Vector getEvents()
        {
                Vector v = new Vector();
                for(Enumeration e = transitions.keys() ; e.hasMoreElements();)
                {
                        v.addElement(e.nextElement());
                }
                return v;
        }
        
        public String toString()
        {
                return getName();
        }
}
